Imports System.ComponentModel
Imports Microsoft.VisualBasic

Public Class FormSettings
    Dim _win As System.Windows.Window

    Public Sub Run(context As JobBox.Interfaces.IRunContext, options As JobBox.Interfaces.IRunOptions)
        Dim sttFile As String = IO.Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.CommonApplicationData), "BechtlePLM", "JobBoxServerAdmin.config")
        Dim sttFileDps As String = IO.Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.CommonApplicationData), "DPS Software", "JobBoxServerAdmin.config")
        
        
        If Not System.IO.File.Exists(sttFile) AndAlso System.IO.File.Exists(sttFileDps) Then
            If Not System.IO.Directory.Exists(System.IO.Path.GetDirectoryName(sttFile))
                System.IO.Directory.CreateDirectory(System.IO.Path.GetDirectoryName(sttFile))
                SetDirectoryAccess(System.IO.Path.GetDirectoryName(sttFile))
            End If
            System.IO.File.Move(sttFileDps, sttFile)
        End If
        
        Dim stt As New DPS.FrameWork.Common.Settings(sttFile)

        Dim settings As New Settings With {
            .ViewBoxDbServer = context.Variable.Get("DB_Server_ViewBox"),
            .ViewBoxDbDatabase = context.Variable.Get("DB_Database_ViewBox"),
            .ViewBoxDbIntegratedSecurity = IIf(context.Variable.Get("DB_IntegratedSecurity_ViewBox").ToLower = "true", True, False),
            .ViewBoxDbUser = context.Variable.Get("DB_User_ViewBox"),
            .ViewBoxDbPassword = context.Variable.Get("DB_Password_ViewBox"),
            .ViewBoxPathGui = context.Variable.Get("Path_ViewBox_GUI"),
            .ViewBoxUpdateToSvg = IIf(context.Variable.Get("Update_ViewBox_SVG").ToLower = "true", True, False),
            .JobBoxDbServer = context.Variable.Get("DB_Server_JobBox"),
            .JobBoxDbDatabase = context.Variable.Get("DB_Database_JobBox"),
            .JobBoxDbIntegratedSecurity = IIf(context.Variable.Get("DB_IntegratedSecurity_JobBox").ToLower = "true", True, False),
            .JobBoxDbUser = context.Variable.Get("DB_User_JobBox"),
            .JobBoxDbPassword = context.Variable.Get("DB_Password_JobBox"),
            .JobBoxLogPath = context.Variable.Get("Path_JobBox_Log")
        }
        stt.ReadClassProperties(settings)

        Select Case GetJobBoxRevision()
            Case < 11143
                settings.SqlType = "ANSI"
            Case < 11317
                settings.SqlType = "BMP"
            Case Else
                settings.ViewBoxUpdateToSvgEnabled = True
        End Select


        ' Pfad zur UI finden
        If String.IsNullOrEmpty(settings.ViewBoxPathGui) OrElse Not System.IO.File.Exists(settings.ViewBoxPathGui) Then
            If System.IO.File.Exists("C:\Program Files\BechtlePLM\ViewBox\ViewBox.Gui.WPF.exe") Then
                settings.ViewBoxPathGui = "C:\Program Files\BechtlePLM\ViewBox\ViewBox.Gui.WPF.exe"
            ElseIf System.IO.File.Exists("C:\Program Files\DPS Software\ViewBox\ViewBox.Gui.WPF.exe") Then
                settings.ViewBoxPathGui = "C:\Program Files\DPS Software\ViewBox\ViewBox.Gui.WPF.exe"
            End If
        End If

        'Pfad u den Logs finden
        If String.IsNullOrEmpty(settings.JobBoxLogPath) OrElse Not System.IO.Directory.Exists(settings.JobBoxLogPath) Then
            If System.IO.Directory.Exists(System.IO.Path.Combine(System.IO.Path.GetDirectoryName(sttFile), "JobBox Server")) Then
                settings.JobBoxLogPath = System.IO.Path.Combine(System.IO.Path.GetDirectoryName(sttFile), "JobBox Server", "Log")
            ElseIf System.IO.Directory.Exists(System.IO.Path.Combine(System.IO.Path.GetDirectoryName(sttFileDps), "JobBox Server")) Then
                settings.JobBoxLogPath = System.IO.Path.Combine(System.IO.Path.GetDirectoryName(sttFileDps), "JobBox Server", "Log")
            End If
        End If

        'Pfad ViewBox Jobs
        context.Variable.Set("%ViewBoxJobs%", System.IO.Path.Combine(System.IO.Path.GetDirectoryName(sttFile), "ViewBox", "Job"))
        If Not System.IO.Directory.Exists(System.IO.Path.Combine(System.IO.Path.GetDirectoryName(sttFile), "ViewBox")) Then
            If System.IO.Directory.Exists(System.IO.Path.Combine(System.IO.Path.GetDirectoryName(sttFileDps), "ViewBox")) Then
                context.Variable.Set("%ViewBoxJobs%", System.IO.Path.Combine(System.IO.Path.GetDirectoryName(sttFileDps), "ViewBox", "Job"))
            Else
                System.IO.Directory.CreateDirectory(System.IO.Path.Combine(System.IO.Path.GetDirectoryName(sttFile), "ViewBox", "Job"))
                SetDirectoryAccess(System.IO.Path.Combine(System.IO.Path.GetDirectoryName(sttFile), "ViewBox", "Job"))
            End If
        End If


        If WindowSettings(settings) Then
            stt.WriteClassProperties(settings)

            context.Variable.Set("Result", "True")
            context.Variable.Set("DB_Server_ViewBox", settings.ViewBoxDbServer)
            context.Variable.Set("DB_Database_ViewBox", settings.ViewBoxDbDatabase)
            context.Variable.Set("DB_IntegratedSecurity_ViewBox", IIf(settings.ViewBoxDbIntegratedSecurity, "True", "False"))
            context.Variable.Set("DB_User_ViewBox", settings.ViewBoxDbUser)
            context.Variable.Set("DB_Password_ViewBox", settings.ViewBoxDbPassword)
            context.Variable.Set("Path_ViewBox_GUI", settings.ViewBoxPathGui)
            context.Variable.Set("Update_ViewBox_SVG", IIf(settings.ViewBoxUpdateToSvg, "True", "False"))
            context.Variable.Set("Path_JobBox_Log", settings.JobBoxLogPath)

            If settings.JobBoxDbEqualsViewBox Then
                context.Variable.Set("DB_Server_JobBox", settings.ViewBoxDbServer)
                context.Variable.Set("DB_Database_JobBox", settings.ViewBoxDbDatabase)
                context.Variable.Set("DB_IntegratedSecurity_JobBox", IIf(settings.ViewBoxDbIntegratedSecurity, "True", "False"))
                context.Variable.Set("DB_User_JobBox", settings.ViewBoxDbUser)
                context.Variable.Set("DB_Password_JobBox", settings.ViewBoxDbPassword)
                context.Variable.Set("DB_Pwd_JobBox", GetText(sttFile, "ViewBoxDbPassword"))
            Else
                context.Variable.Set("DB_Server_JobBox", settings.JobBoxDbServer)
                context.Variable.Set("DB_Database_JobBox", settings.JobBoxDbDatabase)
                context.Variable.Set("DB_IntegratedSecurity_JobBox", IIf(settings.JobBoxDbIntegratedSecurity, "True", "False"))
                context.Variable.Set("DB_User_JobBox", settings.JobBoxDbUser)
                context.Variable.Set("DB_Password_JobBox", settings.JobBoxDbPassword)
                context.Variable.Set("DB_Pwd_JobBox", GetText(sttFile, "JobBoxDbPassword"))
            End If
            context.Variable.Set("%SQLType%", settings.SqlType)
        Else
            context.Variable.Set("Result", "False")
        End If
    End Sub

    Private Function GetText(file As String, prop As String) As String
        Dim ret As String = ""
        Dim xml As New Xml.XmlDocument
        xml.Load(file)
        For Each xmlEle As Xml.XmlElement In xml.SelectNodes("configuration/appSettings/add")
            If xmlEle.GetAttribute("key").Equals(prop) Then
                ret = xmlEle.GetAttribute("value")
                Exit For
            End If
        Next
        Return ret
    End Function

    Private Function GetJobBoxRevision() As Integer
        Dim ass As Reflection.Assembly = Reflection.Assembly.GetEntryAssembly
        Dim an As Reflection.AssemblyName = ass.GetName
        'MsgBox($"{an.Name} : {an.Version.Revision}")
        Return an.Version.Revision
    End Function

    Private Function WindowSettings(settings As Settings) As Boolean
        Dim newThread As System.Threading.Thread = New System.Threading.Thread(AddressOf WindowSettingsShow)
        newThread.SetApartmentState(Threading.ApartmentState.STA)
        newThread.Start(settings)
        newThread.Join()
        Return settings.Ok
    End Function

    Public Sub WindowSettingsShow(settings As Settings)
        _win = New System.Windows.Window
        With _win
            .MinHeight = 530
            .MinWidth = 500
            .Height = 530
            .Width = 700
            .ResizeMode = System.Windows.ResizeMode.CanResizeWithGrip
            .WindowStartupLocation = System.Windows.WindowStartupLocation.CenterOwner
            .WindowStyle = System.Windows.WindowStyle.SingleBorderWindow
            .Title = "Einstellungen für ViewBox und JobBox Server Datenbanken"
            Dim grid As New System.Windows.Controls.Grid
            .Content = grid
            grid.RowDefinitions.Add(New System.Windows.Controls.RowDefinition With {.Height = New System.Windows.GridLength(1, System.Windows.GridUnitType.Star)})
            grid.RowDefinitions.Add(New System.Windows.Controls.RowDefinition With {.Height = New System.Windows.GridLength(40)})

            Dim gridSettings As New System.Windows.Controls.Grid
            grid.Children.Add(gridSettings)
            System.Windows.Controls.Grid.SetRow(gridSettings, 0)

            gridSettings.ColumnDefinitions.Add(New System.Windows.Controls.ColumnDefinition With {.Width = New System.Windows.GridLength(40)})
            gridSettings.ColumnDefinitions.Add(New System.Windows.Controls.ColumnDefinition With {.Width = New System.Windows.GridLength(1, System.Windows.GridUnitType.Auto)})
            gridSettings.ColumnDefinitions.Add(New System.Windows.Controls.ColumnDefinition With {.Width = New System.Windows.GridLength(1, System.Windows.GridUnitType.Star)})

            Dim lbl As System.Windows.Controls.TextBlock
            Dim row As Integer = 0

            Dim marginSection As New System.Windows.Thickness(10, 10, 10, 10)
            Dim marginSettings As New System.Windows.Thickness(10, 10, 10, 0)

#Region "ViewBox"
            'ViewBox
            gridSettings.RowDefinitions.Add(New System.Windows.Controls.RowDefinition With {.Height = New System.Windows.GridLength(1, System.Windows.GridUnitType.Auto)})
            lbl = New System.Windows.Controls.TextBlock With {.Name = "LabelViewBox", .Text = "ViewBox", .Margin = marginSection, .FontWeight = System.Windows.FontWeights.Bold}
            System.Windows.Controls.Grid.SetRow(lbl, row)
            System.Windows.Controls.Grid.SetColumn(lbl, 0)
            System.Windows.Controls.Grid.SetColumnSpan(lbl, 3)
            gridSettings.Children.Add(lbl)
            row += 1

            'Server
            AddTextBox(gridSettings, row, marginSettings, "Server", NameOf(settings.ViewBoxDbServer))
            row += 1
            'Database
            AddTextBox(gridSettings, row, marginSettings, "Database", NameOf(settings.ViewBoxDbDatabase))
            row += 1
            'Integratet Security
            AddCheckBox(gridSettings, row, marginSettings, "Integrated Security", NameOf(settings.ViewBoxDbIntegratedSecurity))
            row += 1
            'User
            AddTextBox(gridSettings, row, marginSettings, "Benutzer", NameOf(settings.ViewBoxDbUser))
            row += 1
            'Password
            With AddPasswordBox(gridSettings, row, marginSettings, "Kennwort", NameOf(settings.ViewBoxDbPassword))
                .Password = settings.ViewBoxDbPassword
            End With
            row += 1

            'Path to GUI
            With AddTextBox(gridSettings, row, marginSettings, "Pfad zur ViewBox", NameOf(settings.ViewBoxPathGui))
                .AddHandler(System.Windows.Controls.TextBox.TextChangedEvent, New System.Windows.RoutedEventHandler(AddressOf OnTextGuiChanged))
            End With
            row += 1

            'SVG
            AddCheckBox(gridSettings, row, marginSettings, $"Standard Bilder der{System.Environment.NewLine}ViewBox mit SVG ersetzen", NameOf(settings.ViewBoxUpdateToSvg), NameOf(settings.ViewBoxUpdateToSvgEnabled))
            row += 1


#End Region

#Region "JobBox"
            'JobBox
            gridSettings.RowDefinitions.Add(New System.Windows.Controls.RowDefinition With {.Height = New System.Windows.GridLength(1, System.Windows.GridUnitType.Auto)})
            lbl = New System.Windows.Controls.TextBlock With {.Name = "LabelJobBox", .Text = "JobBox", .Margin = marginSection, .FontWeight = System.Windows.FontWeights.Bold}
            System.Windows.Controls.Grid.SetRow(lbl, row)
            System.Windows.Controls.Grid.SetColumn(lbl, 0)
            System.Windows.Controls.Grid.SetColumnSpan(lbl, 3)
            gridSettings.Children.Add(lbl)
            row += 1

            'JobBox DB = ViewBox DB
            AddCheckBox(gridSettings, row, marginSettings, "Wie ViewBox", NameOf(settings.JobBoxDbEqualsViewBox))
            row += 1
            'Server
            AddTextBox(gridSettings, row, marginSettings, "Server", NameOf(settings.JobBoxDbServer), NameOf(settings.DbJobBoxEnabled))
            row += 1
            'Database
            AddTextBox(gridSettings, row, marginSettings, "Database", NameOf(settings.JobBoxDbDatabase), NameOf(settings.DbJobBoxEnabled))
            row += 1
            'Integratet Security
            AddCheckBox(gridSettings, row, marginSettings, "Integrated Security", NameOf(settings.JobBoxDbIntegratedSecurity), NameOf(settings.DbJobBoxEnabled))
            row += 1
            'User
            AddTextBox(gridSettings, row, marginSettings, "Benutzer", NameOf(settings.JobBoxDbUser), NameOf(settings.DbJobBoxEnabled))
            row += 1
            'Password

            With AddPasswordBox(gridSettings, row, marginSettings, "Kennwort", NameOf(settings.JobBoxDbPassword), NameOf(settings.DbJobBoxEnabled))
                .Password = settings.JobBoxDbPassword
            End With

            row += 1

            'Path to Log
            With AddTextBox(gridSettings, row, marginSettings, "Pfad Log Dateien", "JobBoxLogPath")
                .AddHandler(System.Windows.Controls.TextBox.TextChangedEvent, New System.Windows.RoutedEventHandler(AddressOf OnTextLogPathChanged))
            End With
            row += 1

#End Region

            Dim cmdOk As New System.Windows.Controls.Button With {.Name = "CmdOk", .Content = "OK", .Margin = New System.Windows.Thickness(10, 10, 130, 10), .Height = 20, .Width = 100, .HorizontalAlignment = System.Windows.HorizontalAlignment.Right, .IsCancel = False}
            grid.Children.Add(cmdOk)
            System.Windows.Controls.Grid.SetRow(cmdOk, 2)
            cmdOk.AddHandler(System.Windows.Controls.Button.ClickEvent, New System.Windows.RoutedEventHandler(AddressOf OnCmdOkClick))

            Dim cmdCancel As New System.Windows.Controls.Button With {.Name = "CmdCancel", .Content = "Cancel", .Margin = New System.Windows.Thickness(10, 10, 10, 10), .Height = 20, .Width = 100, .HorizontalAlignment = System.Windows.HorizontalAlignment.Right, .IsCancel = True}
            grid.Children.Add(cmdCancel)
            System.Windows.Controls.Grid.SetRow(cmdCancel, 2)

        End With

        _win.DataContext = settings

        _win.ShowInTaskbar = True
        If _win.ShowDialog() Then
            If Not settings.JobBoxLogPath.EndsWith("\") Then
                settings.JobBoxLogPath += "\"
            End If

            settings.Ok = True
        End If

        _win = Nothing
    End Sub

    Private Function AddTextBox(grid As System.Windows.Controls.Grid, row As Integer, margin As System.Windows.Thickness, label As String, propertyname As String, Optional enabledProperty As String = "") As System.Windows.Controls.TextBox
        grid.RowDefinitions.Add(New System.Windows.Controls.RowDefinition With {.Height = New System.Windows.GridLength(1, System.Windows.GridUnitType.Auto)})
        Dim lbl As New System.Windows.Controls.TextBlock With {.Name = $"Label{propertyname}", .Text = label, .Margin = margin}
        System.Windows.Controls.Grid.SetRow(lbl, row)
        System.Windows.Controls.Grid.SetColumn(lbl, 1)
        grid.Children.Add(lbl)

        Dim txt As New System.Windows.Controls.TextBox With {.Name = $"Text{propertyname}", .Margin = margin}
        System.Windows.Controls.Grid.SetRow(txt, row)
        System.Windows.Controls.Grid.SetColumn(txt, 2)
        txt.SetBinding(System.Windows.Controls.TextBox.TextProperty, New System.Windows.Data.Binding(propertyname))
        grid.Children.Add(txt)

        If Not String.IsNullOrEmpty(enabledProperty) Then
            lbl.SetBinding(System.Windows.Controls.TextBlock.IsEnabledProperty, New System.Windows.Data.Binding(enabledProperty))
            txt.SetBinding(System.Windows.Controls.TextBox.IsEnabledProperty, New System.Windows.Data.Binding(enabledProperty))
        End If

        Return txt
    End Function

    Private Function AddCheckBox(grid As System.Windows.Controls.Grid, row As Integer, margin As System.Windows.Thickness, label As String, propertyname As String, Optional enabledProperty As String = "") As System.Windows.Controls.CheckBox
        grid.RowDefinitions.Add(New System.Windows.Controls.RowDefinition With {.Height = New System.Windows.GridLength(1, System.Windows.GridUnitType.Auto)})
        Dim lbl As New System.Windows.Controls.TextBlock With {.Name = $"Label{propertyname}", .Text = label, .Margin = margin}
        System.Windows.Controls.Grid.SetRow(lbl, row)
        System.Windows.Controls.Grid.SetColumn(lbl, 1)
        grid.Children.Add(lbl)

        Dim chk As New System.Windows.Controls.CheckBox With {.Name = $"Check{propertyname}", .Margin = margin}
        System.Windows.Controls.Grid.SetRow(chk, row)
        System.Windows.Controls.Grid.SetColumn(chk, 2)
        chk.SetBinding(System.Windows.Controls.CheckBox.IsCheckedProperty, New System.Windows.Data.Binding(propertyname))
        grid.Children.Add(chk)

        If Not String.IsNullOrEmpty(enabledProperty) Then
            lbl.SetBinding(System.Windows.Controls.TextBlock.IsEnabledProperty, New System.Windows.Data.Binding(enabledProperty))
            chk.SetBinding(System.Windows.Controls.CheckBox.IsEnabledProperty, New System.Windows.Data.Binding(enabledProperty))
        End If

        Return chk
    End Function

    Private Function AddPasswordBox(grid As System.Windows.Controls.Grid, row As Integer, margin As System.Windows.Thickness, label As String, propertyname As String, Optional enabledProperty As String = "") As System.Windows.Controls.PasswordBox
        grid.RowDefinitions.Add(New System.Windows.Controls.RowDefinition With {.Height = New System.Windows.GridLength(1, System.Windows.GridUnitType.Auto)})
        Dim lbl As New System.Windows.Controls.TextBlock With {.Name = $"Label{propertyname}", .Text = label, .Margin = margin}
        System.Windows.Controls.Grid.SetRow(lbl, row)
        System.Windows.Controls.Grid.SetColumn(lbl, 1)
        grid.Children.Add(lbl)

        Dim txt As New System.Windows.Controls.PasswordBox With {.Name = $"Password{propertyname}", .Margin = margin}
        System.Windows.Controls.Grid.SetRow(txt, row)
        System.Windows.Controls.Grid.SetColumn(txt, 2)
        txt.Tag = propertyname
        grid.Children.Add(txt)

        If Not String.IsNullOrEmpty(enabledProperty) Then
            lbl.SetBinding(System.Windows.Controls.TextBlock.IsEnabledProperty, New System.Windows.Data.Binding(enabledProperty))
            txt.SetBinding(System.Windows.Controls.PasswordBox.IsEnabledProperty, New System.Windows.Data.Binding(enabledProperty))
        End If

        txt.AddHandler(System.Windows.Controls.PasswordBox.PasswordChangedEvent, New System.Windows.RoutedEventHandler(AddressOf OnPasswordBoxPasswordChanged))

        Return txt
    End Function


    Private Sub OnTextGuiChanged(sender As Object, e As System.Windows.Controls.TextChangedEventArgs)
        Static brush As System.Windows.Media.Brush = Nothing
        Dim txt As System.Windows.Controls.TextBox = TryCast(sender, System.Windows.Controls.TextBox)
        If txt IsNot Nothing Then
            If brush Is Nothing Then
                brush = txt.Background
            End If
            Try
                If IO.File.Exists(txt.Text) Then
                    txt.Background = brush
                Else
                    txt.Background = System.Windows.Media.Brushes.Salmon
                End If
            Catch
                txt.Background = System.Windows.Media.Brushes.Salmon
            End Try
        End If
    End Sub

    Private Sub OnTextLogPathChanged(sender As Object, e As System.Windows.Controls.TextChangedEventArgs)
        Static brush As System.Windows.Media.Brush = Nothing
        Dim txt As System.Windows.Controls.TextBox = TryCast(sender, System.Windows.Controls.TextBox)
        If txt IsNot Nothing Then
            If brush Is Nothing Then
                brush = txt.Background
            End If
            Try
                If IO.Directory.Exists(txt.Text) Then
                    txt.Background = brush
                Else
                    txt.Background = System.Windows.Media.Brushes.Salmon
                End If
            Catch
                txt.Background = System.Windows.Media.Brushes.Salmon
            End Try
        End If
    End Sub


    Private Sub OnCmdOkClick(sender As Object, e As System.Windows.RoutedEventArgs)
        _win.DialogResult = True
    End Sub

    Private Sub OnPasswordBoxPasswordChanged(sender As Object, e As System.Windows.RoutedEventArgs)
        Dim txt As System.Windows.Controls.PasswordBox = TryCast(sender, System.Windows.Controls.PasswordBox)
        If txt IsNot Nothing AndAlso Not String.IsNullOrEmpty(txt.Tag) Then
            Dim settings As Settings = TryCast(txt.DataContext, Settings)
            If settings IsNot Nothing Then
                CallByName(settings, txt.Tag, CallType.Set, txt.Password)
            End If
        End If
    End Sub


    Public Class Settings
        Implements System.ComponentModel.INotifyPropertyChanged

        Public Event PropertyChanged As PropertyChangedEventHandler Implements INotifyPropertyChanged.PropertyChanged

#Region "Dont save"
        <DPS.FrameWork.Common.Settings.SettingsIgnore>
        Public Property Ok As Boolean = False

        <DPS.FrameWork.Common.Settings.SettingsIgnore>
        Public Property SqlType As String = "SVG"

#End Region

#Region "ViewBox"

        Public Property ViewBoxDbServer As String

        Public Property ViewBoxDbDatabase As String

        Public Property ViewBoxDbIntegratedSecurity As Boolean


        Public Property ViewBoxDbUser As String

        <DPS.FrameWork.Common.Settings.SettingsCrypt>
        Public Property ViewBoxDbPassword As String

        Public Property ViewBoxPathGui As String

        <DPS.FrameWork.Common.Settings.SettingsIgnore>
        Public Property ViewBoxUpdateToSvg As Boolean = False

        <DPS.FrameWork.Common.Settings.SettingsIgnore>
        Public Property ViewBoxUpdateToSvgEnabled As Boolean = False

#End Region

#Region "JobBox"
        Private _jobBoxDbEqualsViewBox As Boolean = True
        Public Property JobBoxDbEqualsViewBox As Boolean
            Get
                Return _jobBoxDbEqualsViewBox
            End Get
            Set(value As Boolean)
                _jobBoxDbEqualsViewBox = value
                OnPropertyChanged("JobBoxDbEqualsViewBox")
                OnPropertyChanged("DbJobBoxEnabled")
            End Set
        End Property

        <DPS.FrameWork.Common.Settings.SettingsIgnore>
        Public ReadOnly Property DbJobBoxEnabled As Boolean
            Get
                Return Not _jobBoxDbEqualsViewBox
            End Get
        End Property

        Public Property JobBoxDbServer As String

        Public Property JobBoxDbDatabase As String

        Public Property JobBoxDbIntegratedSecurity As Boolean

        Public Property JobBoxDbUser As String

        <DPS.FrameWork.Common.Settings.SettingsCrypt>
        Public Property JobBoxDbPassword As String

        Public Property JobBoxLogPath As String
#End Region

        Protected Sub OnPropertyChanged(ByVal name As String)
            RaiseEvent PropertyChanged(Me, New PropertyChangedEventArgs(name))
        End Sub

    End Class


    Public Sub RunSetFileAccess(context As JobBox.Interfaces.IRunContext, options As JobBox.Interfaces.IRunOptions)
        Dim sFile As String = context.Variable.Get("File")
        SetFileAccess(sFile)
    End Sub


    Private Sub SetFileAccess(file As String)
        Dim fi As New IO.FileInfo(file)
        Dim fs = fi.GetAccessControl
        'Dim everyOne As New Security.Principal.SecurityIdentifier(Security.Principal.WellKnownSidType.WorldSid, Nothing)
        Dim lst As New List(Of Security.Principal.SecurityIdentifier) From {
            New Security.Principal.SecurityIdentifier(Security.Principal.WellKnownSidType.AuthenticatedUserSid, Nothing),
            New Security.Principal.SecurityIdentifier(Security.Principal.WellKnownSidType.CreatorOwnerSid, Nothing),
            New Security.Principal.SecurityIdentifier(Security.Principal.WellKnownSidType.BuiltinAdministratorsSid, Nothing)
        }
        For Each ident In lst
            fs.AddAccessRule(New Security.AccessControl.FileSystemAccessRule(ident, Security.AccessControl.FileSystemRights.FullControl, Security.AccessControl.AccessControlType.Allow))
        Next
        fi.SetAccessControl(fs)
    End Sub

    Private Sub SetDirectoryAccess(directory As String)
        Dim di As New IO.DirectoryInfo(directory)
        Dim ds = di.GetAccessControl
        'Dim everyOne As New Security.Principal.SecurityIdentifier(Security.Principal.WellKnownSidType.WorldSid, Nothing)
        Dim lst As New List(Of Security.Principal.SecurityIdentifier) From {
            New Security.Principal.SecurityIdentifier(Security.Principal.WellKnownSidType.AuthenticatedUserSid, Nothing),
            New Security.Principal.SecurityIdentifier(Security.Principal.WellKnownSidType.CreatorOwnerSid, Nothing),
            New Security.Principal.SecurityIdentifier(Security.Principal.WellKnownSidType.BuiltinAdministratorsSid, Nothing)
        }
        For Each ident In lst
            ds.AddAccessRule(New Security.AccessControl.FileSystemAccessRule(ident, Security.AccessControl.FileSystemRights.FullControl, Security.AccessControl.InheritanceFlags.ContainerInherit Or Security.AccessControl.InheritanceFlags.ObjectInherit, Security.AccessControl.PropagationFlags.None, Security.AccessControl.AccessControlType.Allow))
        Next
        di.SetAccessControl(ds)
    End Sub

    Public Sub GetJobPath(context As JobBox.Interfaces.IRunContext, options As JobBox.Interfaces.IRunOptions)
        Dim jobpath As String = IO.Path.GetDirectoryName(context.RunInfo(JobBox.Interfaces.IRunContext.RunInfoType.JobFile))
        context.Variable.Set("JobPath", jobpath)
    End Sub



    Public Sub CreateShortcut(context As JobBox.Interfaces.IRunContext, options As JobBox.Interfaces.IRunOptions)
        Dim lnkFileName As String = System.IO.Path.Combine(System.Environment.GetFolderPath(System.Environment.SpecialFolder.Desktop), "JobBox Server Admin.lnk")
        Dim viewbox As String = context.Variable.Get("Path_ViewBox_GUI")
        CreateNewShortcut(lnkFileName, viewbox, "/Class {FC8326B3-588D-4D5C-A72C-DCB0229F5266}", IO.Path.GetDirectoryName(viewbox), "JobBox Server Admin", viewbox, 0)
    End Sub



#Region "Shortcut wrapper"

    <Runtime.InteropServices.ComImport(), Runtime.InteropServices.Guid("00021401-0000-0000-C000-000000000046")>
    Private Class ShellLink
    End Class

    <Runtime.InteropServices.ComImport(), Runtime.InteropServices.InterfaceType(Runtime.InteropServices.ComInterfaceType.InterfaceIsIUnknown), Runtime.InteropServices.Guid("000214F9-0000-0000-C000-000000000046")>
    Private Interface IShellLink
        Sub GetPath(<Runtime.InteropServices.Out, Runtime.InteropServices.MarshalAs(Runtime.InteropServices.UnmanagedType.LPWStr)> pszFile As Text.StringBuilder, cchMaxPath As Integer, <Runtime.InteropServices.Out> ByRef pfd As IntPtr, fFlags As Integer)
        Sub GetIDList(<Runtime.InteropServices.Out> ByRef ppidl As IntPtr)
        Sub SetIDList(pidl As IntPtr)
        Sub GetDescription(<Runtime.InteropServices.Out, Runtime.InteropServices.MarshalAs(Runtime.InteropServices.UnmanagedType.LPWStr)> pszName As Text.StringBuilder, cchMaxName As Integer)
        Sub SetDescription(<Runtime.InteropServices.MarshalAs(Runtime.InteropServices.UnmanagedType.LPWStr)> pszName As String)
        Sub GetWorkingDirectory(<Runtime.InteropServices.Out, Runtime.InteropServices.MarshalAs(Runtime.InteropServices.UnmanagedType.LPWStr)> pszDir As Text.StringBuilder, cchMaxPath As Integer)
        Sub SetWorkingDirectory(<Runtime.InteropServices.MarshalAs(Runtime.InteropServices.UnmanagedType.LPWStr)> pszDir As String)
        Sub GetArguments(<Runtime.InteropServices.Out, Runtime.InteropServices.MarshalAs(Runtime.InteropServices.UnmanagedType.LPWStr)> pszArgs As Text.StringBuilder, cchMaxPath As Integer)
        Sub SetArguments(<Runtime.InteropServices.MarshalAs(Runtime.InteropServices.UnmanagedType.LPWStr)> pszArgs As String)
        Sub GetHotkey(<Runtime.InteropServices.Out> ByRef pwHotkey As Short)
        Sub SetHotkey(wHotkey As Short)
        Sub GetShowCmd(<Runtime.InteropServices.Out> ByRef piShowCmd As Integer)
        Sub SetShowCmd(iShowCmd As Integer)
        Sub GetIconLocation(<Runtime.InteropServices.Out, Runtime.InteropServices.MarshalAs(Runtime.InteropServices.UnmanagedType.LPWStr)> pszIconPath As Text.StringBuilder, cchIconPath As Integer, <Runtime.InteropServices.Out> ByRef piIcon As Integer)
        Sub SetIconLocation(<Runtime.InteropServices.MarshalAs(Runtime.InteropServices.UnmanagedType.LPWStr)> pszIconPath As String, iIcon As Integer)
        Sub SetRelativePath(<Runtime.InteropServices.MarshalAs(Runtime.InteropServices.UnmanagedType.LPWStr)> pszPathRel As String, dwReserved As Integer)
        Sub Resolve(hwnd As IntPtr, fFlags As Integer)
        Sub SetPath(<Runtime.InteropServices.MarshalAs(Runtime.InteropServices.UnmanagedType.LPWStr)> pszFile As String)
    End Interface

    'How to use:
    Private Sub CreateNewShortcut(LNKLocation As String, LNKTarget As String, Optional TargetArgs As String = Nothing, Optional StartFolder As String = Nothing, Optional Description As String = Nothing, Optional IconFile As String = "c:\windows\System32\SHELL32.dll", Optional IconIndex As Integer = 21)
        Dim link As IShellLink = CType(New ShellLink(), IShellLink)
        If Description <> Nothing Then link.SetDescription(Description)
        If TargetArgs <> Nothing Then link.SetArguments(TargetArgs)
        If IconFile <> Nothing Then link.SetIconLocation(IconFile, IconIndex)
        link.SetPath(LNKTarget)
        Dim file As System.Runtime.InteropServices.ComTypes.IPersistFile = CType(link, System.Runtime.InteropServices.ComTypes.IPersistFile)
        file.Save(LNKLocation, False)
    End Sub
#End Region

End Class