CREATE VIEW [dbo].[vwJOBLIST]
AS


WITH CTE AS (
	SELECT A.x.value('x[1]','varchar(500)') AS P01
	,A.x.value('x[2]','varchar(500)') AS P02
	,A.x.value('x[3]','varchar(500)') AS P03
	,A.x.value('x[4]','varchar(500)') AS P04
	,A.x.value('x[5]','varchar(500)') AS P05
	,A.x.value('x[6]','varchar(500)') AS P06
	,A.x.value('x[7]','varchar(500)') AS P07
	,A.x.value('x[8]','varchar(500)') AS P08
	,A.x.value('x[9]','varchar(500)') AS P09
	,A.x.value('x[10]','varchar(500)') AS P10
	,JOBLISTtemp.*
	FROM [JOBLIST] JOBLISTtemp
	CROSS APPLY(SELECT CAST(REPLACE(REPLACE(CAST(JOBLISTtemp.[JOB_PARAMETER] AS nvarchar(max)),'<:','<x>'),':>','</x>') AS XML)) A(x)
)

SELECT	JOB_ID,
		JOB_TYP, 
		JOB_NAME, 
		JOB_RETCODE, 
		CASE JOB_RETCODE WHEN 'False' THEN 'False_JOB_RETCODE' WHEN 'True' THEN 'True_JOB_RETCODE' ELSE '' END AS JOB_RETCODE_DESC,
		CASE JOB_RETCODE WHEN 'False' THEN 'Fehler' WHEN 'True' THEN 'OK' ELSE '' END AS JOB_RETCODE_TEXT,
		P01, P02, P03, P04, P05, P06, P07, P08, P09, P10,
		CONVERT(datetime, JOB_GETDATE, 104) + CONVERT(datetime, JOB_GETTIME, 108) AS JOB_GETDATE, 
		CONVERT(datetime, JOB_RUNDATE, 104) + CONVERT(datetime, JOB_RUNTIME, 108) AS JOB_RUNDATE, 
		CONVERT(datetime, JOB_CLOSEDATE, 104) + CONVERT(datetime, JOB_CLOSETIME, 108) AS JOB_CLOSEDATE, 
		JOB_FROMUSER, 
		JOB_FROMMACHINE, 
		JOB_STATE,
		CASE JOB_STATE WHEN 0 THEN 'Waiting_JOB_STATE' WHEN 1 THEN 'Running_JOB_STATE' WHEN 2 THEN 'Ended_JOB_STATE' END AS JOB_STATE_DESC,
		CASE JOB_STATE WHEN 0 THEN 'wartet' WHEN 1 THEN 'wird ausgeführt' WHEN 2 THEN 'abgeschlossen' ELSE '' END AS JOB_STATE_TEXT,
		JOB_PRIORITY, 
		'%Path_JobBox_Log%' + CONVERT(varchar(50), JOB_ID) + '.dpslog' AS DPSPreview,
		CONVERT(Time, CONVERT(datetime, JOB_CLOSEDATE, 104) + CONVERT(datetime, JOB_CLOSETIME, 108) - CONVERT(datetime, JOB_RUNDATE, 104) - CONVERT(datetime, JOB_RUNTIME, 108)) AS JOB_DURATION,
		JOB_PARAMETER

FROM	[CTE];
