﻿-- the complete database schema
CREATE TABLE IF NOT EXISTS meta (
	key TEXT NOT NULL PRIMARY KEY,
	value TEXT
);

CREATE TABLE IF NOT EXISTS sections (
	uid TEXT NOT NULL PRIMARY KEY
);

CREATE TABLE IF NOT EXISTS sectionsegments (
	id INTEGER NOT NULL PRIMARY KEY,
	sectionuid TEXT NOT NULL REFERENCES sections (uid) ON UPDATE CASCADE ON DELETE CASCADE,
	loopindex INTEGER NOT NULL,
	segmentindex INTEGER NOT NULL,
	UNIQUE (sectionuid, loopindex, segmentindex)
);

CREATE TABLE IF NOT EXISTS sectionlines (
	id INTEGER NOT NULL REFERENCES sectionsegments ON UPDATE CASCADE ON DELETE CASCADE,
	startx REAL NOT NULL,
	starty REAL NOT NULL,
	startz REAL NOT NULL,
	endx REAL NOT NULL,
	endy REAL NOT NULL,
	endz REAL NOT NULL,
	UNIQUE (id)
);

CREATE TABLE IF NOT EXISTS sectionarcs (
	id INTEGER NOT NULL REFERENCES sectionsegments ON UPDATE CASCADE ON DELETE CASCADE,
	centerx REAL NOT NULL,
	centery REAL NOT NULL,
	centerz REAL NOT NULL,
	negativedirection INTEGER NOT NULL,
	startx REAL NOT NULL,
	starty REAL NOT NULL,
	startz REAL NOT NULL,
	endx REAL NOT NULL,
	endy REAL NOT NULL,
	endz REAL NOT NULL,
	axisx REAL NOT NULL,
	axisy REAL NOT NULL,
	axisz REAL NOT NULL,
	UNIQUE (id)
);

-- set the database version
INSERT INTO meta VALUES ('SectionsVersion', '1');
