﻿CREATE TABLE IF NOT EXISTS meta (
    key TEXT NOT NULL PRIMARY KEY,
    value TEXT
);

CREATE TABLE IF NOT EXISTS connections (
    uid TEXT NOT NULL PRIMARY KEY,
    name TEXT NOT NULL,
    type TEXT NOT NULL,
    deleted INTEGER NOT NULL
);

CREATE TABLE IF NOT EXISTS connectiontextdata (
    uid TEXT NOT NULL REFERENCES connections ON UPDATE CASCADE ON DELETE CASCADE,
    key TEXT NOT NULL,
    value TEXT,
    UNIQUE (uid, key)
);

CREATE TABLE IF NOT EXISTS connectionrealdata (
    uid TEXT NOT NULL REFERENCES connections ON UPDATE CASCADE ON DELETE CASCADE,
    key TEXT NOT NULL,
    value REAL,
    UNIQUE (uid, key)
);

CREATE TABLE IF NOT EXISTS connectionintegerdata (
    uid TEXT NOT NULL REFERENCES connections ON UPDATE CASCADE ON DELETE CASCADE,
    key TEXT NOT NULL,
    value INTEGER,
    UNIQUE (uid, key)
);

CREATE TABLE IF NOT EXISTS extrudedcuts (
    uid TEXT NOT NULL PRIMARY KEY,
    connectionuid TEXT NOT NULL REFERENCES connections (uid) ON UPDATE CASCADE ON DELETE CASCADE,
    key TEXT NOT NULL,
    depth REAL NOT NULL,
    sketchfacerootx REAL NOT NULL,
    sketchfacerooty REAL NOT NULL,
    sketchfacerootz REAL NOT NULL,
    sketchfacenormalx REAL NOT NULL,
    sketchfacenormaly REAL NOT NULL,
    sketchfacenormalz REAL NOT NULL,
    UNIQUE (connectionuid, key)
);

CREATE TABLE IF NOT EXISTS parts (
    uid TEXT NOT NULL PRIMARY KEY,
    filename TEXT NOT NULL,
    boxcorner1x REAL NOT NULL,
    boxcorner1y REAL NOT NULL,
    boxcorner1z REAL NOT NULL,
    boxcorner2x REAL NOT NULL,
    boxcorner2y REAL NOT NULL,
    boxcorner2z REAL NOT NULL,
    deleted INTEGER NOT NULL
);

CREATE TABLE IF NOT EXISTS connectionparts (
    connectionuid TEXT NOT NULL REFERENCES connections (uid) ON UPDATE CASCADE ON DELETE CASCADE,
    partuid TEXT NOT NULL REFERENCES parts (uid) ON UPDATE CASCADE ON DELETE CASCADE,
    key TEXT NOT NULL,
    originx REAL NOT NULL,
    originy REAL NOT NULL,
    originz REAL NOT NULL,
    axisxx REAL NOT NULL,
    axisxy REAL NOT NULL,
    axisxz REAL NOT NULL,
    axisyx REAL NOT NULL,
    axisyy REAL NOT NULL,
    axisyz REAL NOT NULL,
    axiszx REAL NOT NULL,
    axiszy REAL NOT NULL,
    axiszz REAL NOT NULL,
    UNIQUE (connectionuid, key)
);

CREATE TABLE IF NOT EXISTS modificationhistory (
    id INTEGER NOT NULL PRIMARY KEY,
    type TEXT NOT NULL,
    uid TEXT NOT NULL
);

INSERT INTO meta VALUES ('AluConnectionsVersion', '1');
